/*
 * Decompiled with CFR 0.152.
 */
package eu.pb4.placeholders.api.parsers;

import eu.pb4.placeholders.api.ParserContext;
import eu.pb4.placeholders.api.PlaceholderContext;
import eu.pb4.placeholders.api.Placeholders;
import eu.pb4.placeholders.api.node.DirectTextNode;
import eu.pb4.placeholders.api.node.LiteralNode;
import eu.pb4.placeholders.api.node.TextNode;
import eu.pb4.placeholders.api.node.TranslatedNode;
import eu.pb4.placeholders.api.node.parent.ParentTextNode;
import eu.pb4.placeholders.api.parsers.NodeParser;
import eu.pb4.placeholders.impl.placeholder.PlaceholderNode;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public record PatternPlaceholderParser(Pattern pattern, Function<String, @Nullable TextNode> placeholderProvider) implements NodeParser
{
    public static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("(?<!((?<!(\\\\))\\\\))[%](?<id>[^%]+:[^%]+)[%]");
    public static final Pattern ALT_PLACEHOLDER_PATTERN = Pattern.compile("(?<!((?<!(\\\\))\\\\))[{](?<id>[^{}]+:[^{}]+)[}]");
    public static final Pattern PLACEHOLDER_PATTERN_CUSTOM = Pattern.compile("(?<!((?<!(\\\\))\\\\))[%](?<id>[^%]+)[%]");
    public static final Pattern ALT_PLACEHOLDER_PATTERN_CUSTOM = Pattern.compile("(?<!((?<!(\\\\))\\\\))[{](?<id>[^{}]+)[}]");
    public static final Pattern PREDEFINED_PLACEHOLDER_PATTERN = Pattern.compile("(?<!((?<!(\\\\))\\\\))\\$[{](?<id>[^}]+)}");

    public static PatternPlaceholderParser of(Pattern pattern, ParserContext.Key<PlaceholderContext> contextKey, Placeholders.PlaceholderGetter placeholders) {
        return new PatternPlaceholderParser(pattern, arg -> {
            String[] args = arg.split(" ", 2);
            if (placeholders.exists(args[0])) {
                return new PlaceholderNode(contextKey, args[0], placeholders, placeholders.isContextOptional(), args.length == 2 ? args[1] : null);
            }
            return null;
        });
    }

    public static PatternPlaceholderParser ofNodeMap(Pattern pattern, Map<String, TextNode> map) {
        return new PatternPlaceholderParser(pattern, map::get);
    }

    public static PatternPlaceholderParser ofTextMap(Pattern pattern, Map<String, class_2561> map) {
        return new PatternPlaceholderParser(pattern, arg -> {
            class_2561 x = (class_2561)map.get(arg);
            return x != null ? new DirectTextNode(x) : null;
        });
    }

    @Override
    public TextNode[] parseNodes(TextNode text) {
        if (text instanceof TranslatedNode) {
            TranslatedNode translatedNode = (TranslatedNode)text;
            ArrayList<Object> list = new ArrayList<Object>();
            for (Object arg : translatedNode.args()) {
                if (arg instanceof TextNode) {
                    TextNode textNode = (TextNode)arg;
                    list.add(TextNode.asSingle(this.parseNodes(textNode)));
                    continue;
                }
                list.add(arg);
            }
            return new TextNode[]{TranslatedNode.ofFallback(translatedNode.key(), translatedNode.fallback(), list.toArray())};
        }
        if (text instanceof LiteralNode) {
            LiteralNode literalNode = (LiteralNode)text;
            ArrayList<TextNode> out = new ArrayList<TextNode>();
            String string = literalNode.value();
            Matcher matcher = this.pattern.matcher(string);
            int previousEnd = 0;
            while (matcher.find()) {
                String placeholder = matcher.group("id");
                int start = matcher.start();
                int end = matcher.end();
                TextNode output = this.placeholderProvider.apply(placeholder);
                if (output != null) {
                    if (start != 0) {
                        out.add(new LiteralNode(string.substring(previousEnd, start)));
                    }
                    out.add(output);
                    previousEnd = end;
                    continue;
                }
                matcher.region(start + 1, string.length());
            }
            if (previousEnd != string.length()) {
                out.add(new LiteralNode(string.substring(previousEnd)));
            }
            return out.toArray(new TextNode[0]);
        }
        if (text instanceof ParentTextNode) {
            ParentTextNode parentNode = (ParentTextNode)text;
            ArrayList<TextNode> out = new ArrayList<TextNode>();
            for (TextNode text1 : parentNode.getChildren()) {
                out.add(TextNode.asSingle(this.parseNodes(text1)));
            }
            return new TextNode[]{parentNode.copyWith(out.toArray(new TextNode[0]), (NodeParser)this)};
        }
        return new TextNode[]{text};
    }
}

